"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const payment_entity_1 = require("../../entities/payment.entity");
const order_entity_1 = require("../../entities/order.entity");
const customer_entity_1 = require("../../entities/customer.entity");
const stripe_service_1 = require("./gateways/stripe.service");
const paypal_service_1 = require("./gateways/paypal.service");
let PaymentsService = class PaymentsService {
    paymentRepo;
    orderRepo;
    customerRepo;
    stripeService;
    paypalService;
    getAllPayments;
    getPaymentStats() {
        throw new Error('Method not implemented.');
    }
    processPayment(processPaymentDto, customerId) {
        throw new Error('Method not implemented.');
    }
    createPaymentIntent(createPaymentDto, customerId) {
        throw new Error('Method not implemented.');
    }
    constructor(paymentRepo, orderRepo, customerRepo, stripeService, paypalService) {
        this.paymentRepo = paymentRepo;
        this.orderRepo = orderRepo;
        this.customerRepo = customerRepo;
        this.stripeService = stripeService;
        this.paypalService = paypalService;
    }
    async createStripePayment(orderId, customerId) {
        const order = await this.orderRepo.findOne({ where: { id: orderId } });
        if (!order) {
            throw new common_1.NotFoundException('Order not found');
        }
        const customer = await this.customerRepo.findOne({ where: { id: Number(customerId) } });
        if (!customer) {
            throw new common_1.NotFoundException('Customer not found');
        }
        const paymentIntent = await this.stripeService.createPaymentIntent(order.totalAmount, 'usd', {
            orderId: order.id,
            customerId: customer.id.toString(),
        });
        const payment = this.paymentRepo.create({
            order: order,
            customer: customer,
            amount: order.totalAmount,
            currency: 'GHS',
            paymentMethod: payment_entity_1.PaymentMethod.STRIPE,
            paymentIntentId: paymentIntent.paymentIntentId,
            status: payment_entity_1.PaymentStatus.PENDING,
        });
        const savedPayment = await this.paymentRepo.save(payment);
        return {
            paymentId: savedPayment.id,
            clientSecret: paymentIntent.clientSecret,
            amount: savedPayment.amount,
            currency: savedPayment.currency,
        };
    }
    async createPaypalPayment(orderId, customerId) {
        const order = await this.orderRepo.findOne({ where: { id: orderId } });
        if (!order) {
            throw new common_1.NotFoundException('Order not found');
        }
        const customer = await this.customerRepo.findOne({ where: { id: Number(customerId) } });
        if (!customer) {
            throw new common_1.NotFoundException('Customer not found');
        }
        const paypalOrder = await this.paypalService.createOrder(order.totalAmount);
        const payment = this.paymentRepo.create({
            order: order,
            customer: customer,
            amount: order.totalAmount,
            currency: 'GHS',
            paymentMethod: payment_entity_1.PaymentMethod.PAYPAL,
            paymentIntentId: paypalOrder.id,
            status: payment_entity_1.PaymentStatus.PENDING,
        });
        const savedPayment = await this.paymentRepo.save(payment);
        return {
            paymentId: savedPayment.id,
            paypalOrderId: paypalOrder.id,
            approvalUrl: paypalOrder.links?.find(link => link.rel === 'approve')?.href,
            amount: savedPayment.amount,
            currency: savedPayment.currency,
        };
    }
    async confirmStripePayment(paymentId, paymentIntentId) {
        const payment = await this.paymentRepo.findOne({ where: { id: paymentId } });
        if (!payment) {
            throw new common_1.NotFoundException('Payment not found');
        }
        const result = await this.stripeService.confirmPayment(paymentIntentId);
        if (result.success) {
            payment.status = payment_entity_1.PaymentStatus.COMPLETED;
            payment.processedAt = new Date();
            await this.paymentRepo.save(payment);
            const order = await this.orderRepo.findOne({ where: { id: payment.orderId } });
            if (order) {
                order.status = order_entity_1.OrderStatus.PAID;
                await this.orderRepo.save(order);
            }
        }
        return {
            success: result.success,
            payment,
        };
    }
    async confirmPaypalPayment(paymentId, orderId) {
        const payment = await this.paymentRepo.findOne({ where: { id: paymentId } });
        if (!payment) {
            throw new common_1.NotFoundException('Payment not found');
        }
        const result = await this.paypalService.captureOrder(orderId);
        if (result.status === 'COMPLETED') {
            payment.status = payment_entity_1.PaymentStatus.COMPLETED;
            payment.processedAt = new Date();
            await this.paymentRepo.save(payment);
            const order = await this.orderRepo.findOne({ where: { id: payment.orderId } });
            if (order) {
                order.status = order_entity_1.OrderStatus.PAID;
                await this.orderRepo.save(order);
            }
        }
        return {
            success: result.status === 'COMPLETED',
            payment,
            paypalResponse: result,
        };
    }
    async getPayment(paymentId, customerId) {
        const payment = await this.paymentRepo.findOne({
            where: { id: paymentId },
            relations: ['order', 'customer'],
        });
        if (!payment) {
            throw new common_1.NotFoundException('Payment not found');
        }
        return payment;
    }
    async getCustomerPayments(customerId) {
        return await this.paymentRepo.find({
            where: { customerId: Number(customerId) },
            relations: ['order'],
            order: { createdAt: 'DESC' },
        });
    }
    async refundPayment(paymentId, refundPaymentDto, amount) {
        const payment = await this.paymentRepo.findOne({ where: { id: paymentId } });
        if (!payment) {
            throw new common_1.NotFoundException('Payment not found');
        }
        if (payment.status !== payment_entity_1.PaymentStatus.COMPLETED) {
            throw new common_1.BadRequestException('Only completed payments can be refunded');
        }
        let refund;
        if (payment.paymentMethod === payment_entity_1.PaymentMethod.STRIPE && payment.paymentIntentId) {
            refund = await this.stripeService.createRefund(payment.paymentIntentId, amount);
        }
        else {
            throw new common_1.BadRequestException('Refund not supported for this payment method');
        }
        if (refund) {
            payment.status = payment_entity_1.PaymentStatus.REFUNDED;
            payment.refundedAt = new Date();
            await this.paymentRepo.save(payment);
            const order = await this.orderRepo.findOne({ where: { id: payment.orderId } });
            if (order) {
                order.status = order_entity_1.OrderStatus.REFUNDED;
                await this.orderRepo.save(order);
            }
        }
        return {
            refund,
            payment,
        };
    }
};
exports.PaymentsService = PaymentsService;
exports.PaymentsService = PaymentsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(payment_entity_1.Payment)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __param(2, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        stripe_service_1.StripeService,
        paypal_service_1.PaypalService])
], PaymentsService);
//# sourceMappingURL=payments.service.js.map